define(['angular', 'app','FitnessActivityFHIRService','FitnessGoalsFHIRService','moment'], function (angular, app, moment) {
    "use strict";

    app.service('FitnessService', function ($q, $modal, HomePageConstants, TrackersFHIRService, FitnessServiceConstants, FitnessActivityFHIRService,FitnessGoalsFHIRService) {


        var FitnessService = {};
        FitnessService.instances = {};

        FitnessService.initializedPromise = null;
        FitnessService.dataPointers = {
            assessments: null
        };


        FitnessService.instance = function (key) {

            if (key === 'fitnessActivities') {

                FitnessService.instances.fitnessActivities = FitnessActivityFHIRService;
            }
            else {

                FitnessService.instances.goalHistory = FitnessGoalsFHIRService;
            }

              return FitnessService.instances[key];
        };





		FitnessService.openGoalsModal = function (details) {

			var defer = $q.defer(),
				modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/ui-components/modals/set-goals/set-goals_template.html',
				controller:'SetGoalsModalController',
				resolve: {
					data: function () {
						return details;
					}
				}
			});





			modalInstance.result.then(function (editedGoal) {
			    if (editedGoal.extensions) {

                    //combinedDateTime.format('YYYY-MM-DDTHH:mm:ssZ');





                    delete editedGoal.extensions;
			        delete editedGoal.activeFlag;
                    delete editedGoal.startDate;
                    delete editedGoal.endDate;
                    delete editedGoal.target;
                    delete editedGoal.progress;

                }
				defer.resolve(editedGoal);
			}, function(){
				defer.reject();
			});

			return defer.promise;
		};

        function setGoalDetails(editedGoal, details) {

            setGoalTarget('minutes', editedGoal);
            setGoalTarget('steps', editedGoal);
            setGoalTarget('miles', editedGoal);
        }


        function setGoalTarget(target, details) {

            if (!details.target[target]) {
                delete details.target[target]
            }
        }

        return FitnessService;
    });
});